<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Phone extends Model 
{

    protected $table = 'phones';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function brand()
    {
        return $this->hasOne('App\Models\Brand', 'id');
    }

    public function phoneseries()
    {
        return $this->hasOne('App\Models\BrandSeries', 'id');
    }

}